CONTAINER Mhairmaterial
{
	NAME Mhairmaterial;

	INCLUDE Mpreview;
	INCLUDE Mbase;

	GROUP Obaselist
	{
		GROUP
		{
			COLUMNS 2; MATEDCOLUMNS 1;

			BOOL HAIRMATERIAL_USE_COLOR { PARENTMSG HAIRMATERIAL_GROUP_COLOR; }
			BOOL HAIRMATERIAL_USE_BACK_COLOR { PARENTMSG HAIRMATERIAL_GROUP_BACK_COLOR; }
			BOOL HAIRMATERIAL_USE_LIGHTING { PARENTMSG HAIRMATERIAL_GROUP_LIGHTING; }
			BOOL HAIRMATERIAL_USE_TRANSPARENCY { PARENTMSG HAIRMATERIAL_GROUP_TRANSPARENCY; }
			BOOL HAIRMATERIAL_USE_THICKNESS { PARENTMSG HAIRMATERIAL_GROUP_THICKNESS; }
			BOOL HAIRMATERIAL_USE_LENGTH { PARENTMSG HAIRMATERIAL_GROUP_LENGTH; }
			BOOL HAIRMATERIAL_USE_SCALE { PARENTMSG HAIRMATERIAL_GROUP_SCALE; }
			BOOL HAIRMATERIAL_USE_FRIZZ { PARENTMSG HAIRMATERIAL_GROUP_FRIZZ; }
			BOOL HAIRMATERIAL_USE_KINK { PARENTMSG HAIRMATERIAL_GROUP_KINK; }

			BOOL HAIRMATERIAL_USE_DENSITY { PARENTMSG HAIRMATERIAL_GROUP_DENSITY; }
			BOOL HAIRMATERIAL_USE_CLUMP { PARENTMSG HAIRMATERIAL_GROUP_CLUMP; }
			BOOL HAIRMATERIAL_USE_TIGHTEN { PARENTMSG HAIRMATERIAL_GROUP_TIGHTEN; }
			BOOL HAIRMATERIAL_USE_DISPLACE { PARENTMSG HAIRMATERIAL_GROUP_DISPLACE; }
			BOOL HAIRMATERIAL_USE_BEND { PARENTMSG HAIRMATERIAL_GROUP_BEND; }
			BOOL HAIRMATERIAL_USE_CURL { PARENTMSG HAIRMATERIAL_GROUP_CURL; }
			BOOL HAIRMATERIAL_USE_TWIST { PARENTMSG HAIRMATERIAL_GROUP_TWIST; }
			BOOL HAIRMATERIAL_USE_WAVE { PARENTMSG HAIRMATERIAL_GROUP_WAVE; }
			BOOL HAIRMATERIAL_USE_STRAIGHTEN { PARENTMSG HAIRMATERIAL_GROUP_STRAIGHTEN; }

			BOOL HAIRMATERIAL_PAGE_ASSIGNMENT { PAGE; HIDDEN; PARENTMSG HAIRMATERIAL_GROUP_ASSIGN; }
			BOOL HAIRMATERIAL_MATERIAL_PAGE_ILLUMINATION	{ PAGE; HIDDEN; PARENTMSG HAIRMATERIAL_ID_MATERIALGROUP_ILLUMINATION; }
		}
	}

	GROUP HAIRMATERIAL_GROUP_COLOR
	{
		DEFAULT 1; HIDDEN;

		GRADIENT HAIRMATERIAL_COLOR_GRADIENT { COLOR; ICC_BASEDOCUMENT; }

		REAL HAIRMATERIAL_COLOR_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { }

		SHADERLINK HAIRMATERIAL_COLOR_SHADER { }

		GROUP
		{
			COLUMNS 3;

			LONG HAIRMATERIAL_COLOR_BLEND
			{
				CYCLE
				{
					HAIRMATERIAL_BLENDMODE_AVERAGE;
					HAIRMATERIAL_BLENDMODE_NORMAL;
					HAIRMATERIAL_BLENDMODE_MULTIPLY;
					HAIRMATERIAL_BLENDMODE_SCREEN;
					HAIRMATERIAL_BLENDMODE_DARKEN;
					HAIRMATERIAL_BLENDMODE_LIGHT;
					HAIRMATERIAL_BLENDMODE_DIFFERENCE;
					HAIRMATERIAL_BLENDMODE_NEGATIVE;
					HAIRMATERIAL_BLENDMODE_EXCLUSION;
					HAIRMATERIAL_BLENDMODE_OVERLAY;
					HAIRMATERIAL_BLENDMODE_HARDLIGHT;
					HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
					HAIRMATERIAL_BLENDMODE_DODGE;
					HAIRMATERIAL_BLENDMODE_BURN;
					HAIRMATERIAL_BLENDMODE_REFLECT;
					HAIRMATERIAL_BLENDMODE_GLOW;
					HAIRMATERIAL_BLENDMODE_FREEZE;
					HAIRMATERIAL_BLENDMODE_HEAT;
					HAIRMATERIAL_BLENDMODE_ADD;
					HAIRMATERIAL_BLENDMODE_SUB;
					HAIRMATERIAL_BLENDMODE_STAMP;
					HAIRMATERIAL_BLENDMODE_XOR;
					HAIRMATERIAL_BLENDMODE_HUE;
					HAIRMATERIAL_BLENDMODE_SATURATION;
					HAIRMATERIAL_BLENDMODE_LUMINANCE;
					HAIRMATERIAL_BLENDMODE_RED;
					HAIRMATERIAL_BLENDMODE_GREEN;
					HAIRMATERIAL_BLENDMODE_BLUE;
					HAIRMATERIAL_BLENDMODE_OVERWRITE;
					HAIRMATERIAL_BLENDMODE_LEVR;
				}
			}

			REAL HAIRMATERIAL_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
		}

		SEPARATOR { }

		GROUP
		{
			COLUMNS 4;

			STATICTEXT HAIRMATERIAL_HSV_VAR { NOTEXT; }

			REAL HAIRMATERIAL_H_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
			REAL HAIRMATERIAL_S_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
			REAL HAIRMATERIAL_V_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}
	
		GROUP HAIRMATERIAL_GROUP_COLOR_ROOTS
		{
			SHADERLINK HAIRMATERIAL_COLOR_HAIR_ROOTS_SHADER { }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_ROOTS_COLOR_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_ROOTS_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_COLOR_TIPS
		{
			BOOL HAIRMATERIAL_COLOR_HAIR_TIPS_LINK { }

			SHADERLINK HAIRMATERIAL_COLOR_HAIR_TIPS_SHADER { }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_TIPS_COLOR_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_TIPS_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_COLOR_MUTANT
		{
			SHADERLINK HAIRMATERIAL_MUTANT_COLOR {  }

			REAL HAIRMATERIAL_MUTANT_LEVEL { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_MUTANT_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_MUTANT_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_COLOR_SURFACE
		{
			BOOL HAIRMATERIAL_COLOR_SURFACE { }

			GROUP
			{
				COLUMNS 3;

				BOOL HAIRMATERIAL_COLOR_SURFACE_COLOR { }
				BOOL HAIRMATERIAL_COLOR_SURFACE_ILLUMINATION { }
				BOOL HAIRMATERIAL_COLOR_SURFACE_SHADOW { }
			}

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_SURFACE_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_SURFACE_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}
	}

	GROUP HAIRMATERIAL_GROUP_BACK_COLOR
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 3;

			LONG HAIRMATERIAL_BACK_FRONT_COLOR_BLEND
			{
				CYCLE
				{
					HAIRMATERIAL_BLENDMODE_AVERAGE;
					HAIRMATERIAL_BLENDMODE_NORMAL;
					HAIRMATERIAL_BLENDMODE_MULTIPLY;
					HAIRMATERIAL_BLENDMODE_SCREEN;
					HAIRMATERIAL_BLENDMODE_DARKEN;
					HAIRMATERIAL_BLENDMODE_LIGHT;
					HAIRMATERIAL_BLENDMODE_DIFFERENCE;
					HAIRMATERIAL_BLENDMODE_NEGATIVE;
					HAIRMATERIAL_BLENDMODE_EXCLUSION;
					HAIRMATERIAL_BLENDMODE_OVERLAY;
					HAIRMATERIAL_BLENDMODE_HARDLIGHT;
					HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
					HAIRMATERIAL_BLENDMODE_DODGE;
					HAIRMATERIAL_BLENDMODE_BURN;
					HAIRMATERIAL_BLENDMODE_REFLECT;
					HAIRMATERIAL_BLENDMODE_GLOW;
					HAIRMATERIAL_BLENDMODE_FREEZE;
					HAIRMATERIAL_BLENDMODE_HEAT;
					HAIRMATERIAL_BLENDMODE_ADD;
					HAIRMATERIAL_BLENDMODE_SUB;
					HAIRMATERIAL_BLENDMODE_STAMP;
					HAIRMATERIAL_BLENDMODE_XOR;
					HAIRMATERIAL_BLENDMODE_HUE;
					HAIRMATERIAL_BLENDMODE_SATURATION;
					HAIRMATERIAL_BLENDMODE_LUMINANCE;
					HAIRMATERIAL_BLENDMODE_RED;
					HAIRMATERIAL_BLENDMODE_GREEN;
					HAIRMATERIAL_BLENDMODE_BLUE;
					HAIRMATERIAL_BLENDMODE_OVERWRITE;
					HAIRMATERIAL_BLENDMODE_LEVR;
				}
			}

			REAL HAIRMATERIAL_BACK_FRONT_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
		}

		SEPARATOR { }

		GRADIENT HAIRMATERIAL_BACK_COLOR_GRADIENT { COLOR; ICC_BASEDOCUMENT; }

		REAL HAIRMATERIAL_BACK_COLOR_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { }

		SHADERLINK HAIRMATERIAL_BACK_COLOR_SHADER { }

		GROUP
		{
			COLUMNS 3;

			LONG HAIRMATERIAL_BACK_COLOR_BLEND
			{
				CYCLE
				{
					HAIRMATERIAL_BLENDMODE_AVERAGE;
					HAIRMATERIAL_BLENDMODE_NORMAL;
					HAIRMATERIAL_BLENDMODE_MULTIPLY;
					HAIRMATERIAL_BLENDMODE_SCREEN;
					HAIRMATERIAL_BLENDMODE_DARKEN;
					HAIRMATERIAL_BLENDMODE_LIGHT;
					HAIRMATERIAL_BLENDMODE_DIFFERENCE;
					HAIRMATERIAL_BLENDMODE_NEGATIVE;
					HAIRMATERIAL_BLENDMODE_EXCLUSION;
					HAIRMATERIAL_BLENDMODE_OVERLAY;
					HAIRMATERIAL_BLENDMODE_HARDLIGHT;
					HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
					HAIRMATERIAL_BLENDMODE_DODGE;
					HAIRMATERIAL_BLENDMODE_BURN;
					HAIRMATERIAL_BLENDMODE_REFLECT;
					HAIRMATERIAL_BLENDMODE_GLOW;
					HAIRMATERIAL_BLENDMODE_FREEZE;
					HAIRMATERIAL_BLENDMODE_HEAT;
					HAIRMATERIAL_BLENDMODE_ADD;
					HAIRMATERIAL_BLENDMODE_SUB;
					HAIRMATERIAL_BLENDMODE_STAMP;
					HAIRMATERIAL_BLENDMODE_XOR;
					HAIRMATERIAL_BLENDMODE_HUE;
					HAIRMATERIAL_BLENDMODE_SATURATION;
					HAIRMATERIAL_BLENDMODE_LUMINANCE;
					HAIRMATERIAL_BLENDMODE_RED;
					HAIRMATERIAL_BLENDMODE_GREEN;
					HAIRMATERIAL_BLENDMODE_BLUE;
					HAIRMATERIAL_BLENDMODE_OVERWRITE;
					HAIRMATERIAL_BLENDMODE_LEVR;
				}
			}

			REAL HAIRMATERIAL_BACK_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
		}

		SEPARATOR { }

		GROUP
		{
			COLUMNS 4;

			STATICTEXT HAIRMATERIAL_BACK_HSV_VAR { NOTEXT; }

			REAL HAIRMATERIAL_BACK_H_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
			REAL HAIRMATERIAL_BACK_S_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
			REAL HAIRMATERIAL_BACK_V_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}
	
		GROUP HAIRMATERIAL_GROUP_BACK_COLOR_ROOTS
		{
			SHADERLINK HAIRMATERIAL_BACK_COLOR_HAIR_ROOTS_SHADER { }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_ROOTS_BACK_COLOR_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_ROOTS_BACK_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_BACK_COLOR_TIPS
		{
			BOOL HAIRMATERIAL_BACK_COLOR_HAIR_TIPS_LINK { }

			SHADERLINK HAIRMATERIAL_BACK_COLOR_HAIR_TIPS_SHADER { }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_TIPS_BACK_COLOR_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_TIPS_BACK_COLOR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_BACK_COLOR_MUTANT
		{
			SHADERLINK HAIRMATERIAL_MUTANT_BACK_COLOR {  }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_BACK_MUTANT_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_BACK_MUTANT_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_BACK_COLOR_SURFACE
		{
			BOOL HAIRMATERIAL_BACK_COLOR_SURFACE { }

			GROUP
			{
				COLUMNS 3;

				BOOL HAIRMATERIAL_BACK_COLOR_SURFACE_COLOR { }
				BOOL HAIRMATERIAL_BACK_COLOR_SURFACE_ILLUMINATION { }
				BOOL HAIRMATERIAL_BACK_COLOR_SURFACE_SHADOW { }
			}

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_BACK_SURFACE_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_BACK_SURFACE_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}
	}

	GROUP HAIRMATERIAL_GROUP_LIGHTING
	{
		GROUP HAIRMATERIAL_GROUP_LIGHTING_PRIMARY
		{
			DEFAULT 1;

			COLOR HAIRMATERIAL_LIGHTING_SPECULAR_COLOR { OPEN;  }

			SEPARATOR { }

			REAL HAIRMATERIAL_LIGHTING_SPECULAR_STRENGTH	{ UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL HAIRMATERIAL_LIGHTING_SPECULAR_POWER	{ MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

			SHADERLINK HAIRMATERIAL_LIGHTING_SPECULAR_SHADER { }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_LIGHTING_SPECULAR_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_LIGHTING_SPECULAR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		GROUP HAIRMATERIAL_GROUP_LIGHTING_SECONDARY
		{
			DEFAULT 1;

			REAL HAIRMATERIAL_LIGHTING_ISPECULAR_STRENGTH	{ UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL HAIRMATERIAL_LIGHTING_ISPECULAR_POWER	{ MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

			SHADERLINK HAIRMATERIAL_LIGHTING_ISPECULAR_SHADER { }

			GROUP
			{
				COLUMNS 3;

				LONG HAIRMATERIAL_LIGHTING_ISPECULAR_BLEND
				{
					CYCLE
					{
						HAIRMATERIAL_BLENDMODE_AVERAGE;
						HAIRMATERIAL_BLENDMODE_NORMAL;
						HAIRMATERIAL_BLENDMODE_MULTIPLY;
						HAIRMATERIAL_BLENDMODE_SCREEN;
						HAIRMATERIAL_BLENDMODE_DARKEN;
						HAIRMATERIAL_BLENDMODE_LIGHT;
						HAIRMATERIAL_BLENDMODE_DIFFERENCE;
						HAIRMATERIAL_BLENDMODE_NEGATIVE;
						HAIRMATERIAL_BLENDMODE_EXCLUSION;
						HAIRMATERIAL_BLENDMODE_OVERLAY;
						HAIRMATERIAL_BLENDMODE_HARDLIGHT;
						HAIRMATERIAL_BLENDMODE_SOFTLIGHT;
						HAIRMATERIAL_BLENDMODE_DODGE;
						HAIRMATERIAL_BLENDMODE_BURN;
						HAIRMATERIAL_BLENDMODE_REFLECT;
						HAIRMATERIAL_BLENDMODE_GLOW;
						HAIRMATERIAL_BLENDMODE_FREEZE;
						HAIRMATERIAL_BLENDMODE_HEAT;
						HAIRMATERIAL_BLENDMODE_ADD;
						HAIRMATERIAL_BLENDMODE_SUB;
						HAIRMATERIAL_BLENDMODE_STAMP;
						HAIRMATERIAL_BLENDMODE_XOR;
						HAIRMATERIAL_BLENDMODE_HUE;
						HAIRMATERIAL_BLENDMODE_SATURATION;
						HAIRMATERIAL_BLENDMODE_LUMINANCE;
						HAIRMATERIAL_BLENDMODE_RED;
						HAIRMATERIAL_BLENDMODE_GREEN;
						HAIRMATERIAL_BLENDMODE_BLUE;
						HAIRMATERIAL_BLENDMODE_OVERWRITE;
						HAIRMATERIAL_BLENDMODE_LEVR;
					}
				}

				REAL HAIRMATERIAL_LIGHTING_ISPECULAR_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT { JOINENDSCALE; }
			}
		}

		SEPARATOR { LINE; }

		REAL HAIRMATERIAL_LIGHTING_SPECULAR_BACK	{ UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP HAIRMATERIAL_GROUP_TRANSPARENCY
	{
		GRADIENT HAIRMATERIAL_LIGHTING_TRANSPARENCY_GRADIENT { ALPHA; ICC_BASEDOCUMENT; }

		REAL HAIRMATERIAL_LIGHTING_TRANSPARENCY	{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { }

		BOOL HAIRMATERIAL_LIGHTING_TRANSPARENCY_INVERT { }

		SEPARATOR { }

		SHADERLINK HAIRMATERIAL_LIGHTING_TRANSPARENCY_SHADER { }

		GROUP
		{
			COLUMNS 3;

			LONG HAIRMATERIAL_LIGHTING_TRANSPARENCY_BLEND
			{
				CYCLE
				{
					HAIRMATERIAL_BLENDMODE_AVERAGE;
					HAIRMATERIAL_BLENDMODE_NORMAL;
					HAIRMATERIAL_BLENDMODE_MULTIPLY;
					HAIRMATERIAL_BLENDMODE_DIFFERENCE;
					HAIRMATERIAL_BLENDMODE_NEGATIVE;
					HAIRMATERIAL_BLENDMODE_ADD;
					HAIRMATERIAL_BLENDMODE_SUB;
					HAIRMATERIAL_BLENDMODE_XOR;
					HAIRMATERIAL_BLENDMODE_OVERWRITE;
					HAIRMATERIAL_BLENDMODE_LEVR;
				}
			}

			REAL HAIRMATERIAL_LIGHTING_TRANSPARENCY_MIX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
		}
	}

	GROUP HAIRMATERIAL_GROUP_THICKNESS
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_THICKNESS_ROOT { UNIT METER; MIN 0.0; STEP 0.1; }
			REAL HAIRMATERIAL_THICKNESS_TIP { UNIT METER; MIN 0.0; STEP 0.1; }

			REAL HAIRMATERIAL_THICKNESS_VAR	{ UNIT METER; MIN 0.0; STEP 0.1; }
			STATICTEXT { NEWLINE; }
		}

		SPLINE HAIRMATERIAL_THICKNESS_CURVE
		{
		}

		SHADERLINK HAIRMATERIAL_THICKNESS_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_LENGTH
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_LENGTH	{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
			REAL HAIRMATERIAL_LENGTH_VAR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		REAL HAIRMATERIAL_LENGTH_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SHADERLINK HAIRMATERIAL_LENGTH_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_SCALE
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_SCALE	{ UNIT PERCENT; MIN 0.0; }
			REAL HAIRMATERIAL_SCALE_VAR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		REAL HAIRMATERIAL_SCALE_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SHADERLINK HAIRMATERIAL_SCALE_SHADER { }
	}
	
	GROUP HAIRMATERIAL_GROUP_FRIZZ
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_FRIZZ { UNIT PERCENT; }
			REAL HAIRMATERIAL_FRIZZ_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }

			REAL HAIRMATERIAL_FRIZZ_SCALE_X	{ UNIT PERCENT; MIN 0.0; }
			REAL HAIRMATERIAL_FRIZZ_SCALE_Y	{ UNIT PERCENT; MIN 0.0; }
		}

		REAL HAIRMATERIAL_FRIZZ_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SPLINE HAIRMATERIAL_FRIZZ_CURVE
		{ 
		}

		SHADERLINK HAIRMATERIAL_FRIZZ_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_KINK
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;
		
			REAL HAIRMATERIAL_KINK { UNIT PERCENT; }
			REAL HAIRMATERIAL_KINK_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }

			REAL HAIRMATERIAL_KINK_SCALE_X	{ UNIT PERCENT; MIN 0.0; }
			REAL HAIRMATERIAL_KINK_SCALE_Y	{ UNIT PERCENT; MIN 0.0; }
		}

		REAL HAIRMATERIAL_KINK_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SPLINE HAIRMATERIAL_KINK_CURVE
		{ 
		}

		SHADERLINK HAIRMATERIAL_KINK_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_DENSITY
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_DENSITY	{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
			LONG HAIRMATERIAL_DENSITY_LEVELS { MIN 2; MAX 10000.0; }
		}

		SHADERLINK HAIRMATERIAL_DENSITY_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_CLUMP
	{
		HIDDEN;
		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_CLUMP_NUMBER { UNIT PERCENT; MIN 0.0; MAX 100.0; }
			STATICTEXT { NEWLINE; }

			REAL HAIRMATERIAL_CLUMP { UNIT PERCENT; MIN -100.0; MAX 100.0; }
			REAL HAIRMATERIAL_CLUMP_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }

			REAL HAIRMATERIAL_CLUMP_RADIUS { UNIT METER; MIN 0.0; }
			REAL HAIRMATERIAL_CLUMP_RADIUS_VAR { UNIT METER; MIN 0.0; }

			REAL HAIRMATERIAL_CLUMP_TWIST { UNIT DEGREE; }
			REAL HAIRMATERIAL_CLUMP_TWIST_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		GROUP HAIRMATERIAL_GROUP_CLUMP_ADVANCED
		{
			GROUP
			{
				COLUMNS 2;

				LONG HAIRMATERIAL_CLUMP_MAX	{ MIN 1; }
				STATICTEXT { NEWLINE; }

				BOOL HAIRMATERIAL_CLUMP_INC_ROOTS { }
				BOOL HAIRMATERIAL_CLUMP_RETAIN_LENGTH { }
			}

			SPLINE HAIRMATERIAL_CLUMP_CURVE
			{ 
				Y_MIN -1; 
				Y_MAX 1; 
			}

			SPLINE HAIRMATERIAL_CLUMP_FALLOFF_CURVE
			{ 
			}

			SHADERLINK HAIRMATERIAL_CLUMP_SHADER { }
			SHADERLINK HAIRMATERIAL_CLUMP_RADIUS_SHADER { }
		}

		GROUP HAIRMATERIAL_GROUP_CLUMP_TWIST
		{
			SPLINE HAIRMATERIAL_CLUMP_TWIST_CURVE
			{ 
				Y_MIN -1; 
				Y_MAX 1; 
			}

			SPLINE HAIRMATERIAL_CLUMP_TWIST_FALLOFF_CURVE
			{ 
			}

			SHADERLINK HAIRMATERIAL_CLUMP_TWIST_SHADER { }
		}
	}

	GROUP HAIRMATERIAL_GROUP_TIGHTEN
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_TIGHTEN { UNIT PERCENT; MIN -100.0; MAX 100.0; }
			REAL HAIRMATERIAL_TIGHTEN_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		REAL HAIRMATERIAL_TIGHTEN_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SPLINE HAIRMATERIAL_TIGHTEN_CURVE
		{ 
		}

		SHADERLINK HAIRMATERIAL_TIGHTEN_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_DISPLACE
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;
		
			LONG HAIRMATERIAL_DISPLACE_DIRECTION
			{
				CYCLE
				{
					HAIRMATERIAL_DISPLACE_DIRECTION_WORLD;
					HAIRMATERIAL_DISPLACE_DIRECTION_LOCAL;
					//HAIRMATERIAL_DISPLACE_DIRECTION_HAIR;
				}
			}
			BOOL HAIRMATERIAL_DISPLACE_RELATIVE { }

			
			REAL HAIRMATERIAL_DISPLACE_ABS { UNIT METER; }
			REAL HAIRMATERIAL_DISPLACE_ABS_VAR { UNIT METER; }

			REAL HAIRMATERIAL_DISPLACE { UNIT PERCENT; }
			REAL HAIRMATERIAL_DISPLACE_VAR { UNIT PERCENT; }
		}

		REAL HAIRMATERIAL_DISPLACE_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SPLINE HAIRMATERIAL_DISPLACE_CURVE_X { Y_MIN -1; Y_MAX 1; }
		SPLINE HAIRMATERIAL_DISPLACE_CURVE_Y { Y_MIN -1; Y_MAX 1; }
		SPLINE HAIRMATERIAL_DISPLACE_CURVE_Z { Y_MIN -1; Y_MAX 1; }
		
		GROUP HAIRMATERIAL_GROUP_DISPLACE_ADVANCED
		{
			GROUP
			{
				COLUMNS 2;
				
				BOOL HAIRMATERIAL_DISPLACE_ROOT { }
				STATICTEXT { NEWLINE; }

				BOOL HAIRMATERIAL_DISPLACE_ADDITIVE { }
				BOOL HAIRMATERIAL_DISPLACE_SCALE_SEGMENTS { }
			}

			SPLINE HAIRMATERIAL_DISPLACE_CURVE { Y_MIN -1; Y_MAX 1; }

			SHADERLINK HAIRMATERIAL_DISPLACE_SHADER { }
			SHADERLINK HAIRMATERIAL_DISPLACE_DN_SHADER { }
		}
	}

	GROUP HAIRMATERIAL_GROUP_BEND
	{
		HIDDEN;

		GROUP 
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_BEND { UNIT PERCENT; }
			REAL HAIRMATERIAL_BEND_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		REAL HAIRMATERIAL_BEND_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		
		GROUP 
		{
			COLUMNS 2;

			LONG HAIRMATERIAL_BEND_DIRECTION
			{
				CYCLE
				{
					HAIRMATERIAL_BEND_DIRECTION_WORLD;
					HAIRMATERIAL_BEND_DIRECTION_LOCAL;
					HAIRMATERIAL_BEND_DIRECTION_RANDOM;
					HAIRMATERIAL_BEND_DIRECTION_OBJECT;
				}
			}

			REAL HAIRMATERIAL_BEND_DN_VAR { UNIT PERCENT; MIN -100.0; MAX 100.0; }

			LONG HAIRMATERIAL_BEND_DIRECTION_AXIS
			{
				CYCLE
				{
					HAIRMATERIAL_BEND_DIRECTION_AXIS_X;
					HAIRMATERIAL_BEND_DIRECTION_AXIS_Y;
					HAIRMATERIAL_BEND_DIRECTION_AXIS_Z;
					HAIRMATERIAL_BEND_DIRECTION_AXIS_NX;
					HAIRMATERIAL_BEND_DIRECTION_AXIS_NY;
					HAIRMATERIAL_BEND_DIRECTION_AXIS_NZ;
					HAIRMATERIAL_BEND_DIRECTION_AXIS_SHADER;
				}
			}

			STATICTEXT { NEWLINE; }
		}

		SHADERLINK HAIRMATERIAL_BEND_DN_SHADER { }
		
		LINK HAIRMATERIAL_BEND_DN_OBJECT { ACCEPT { Obase; } }

		GROUP HAIRMATERIAL_GROUP_BEND_ADVANCED
		{
			BOOL HAIRMATERIAL_BEND_ROOT { }

			SPLINE HAIRMATERIAL_BEND_CURVE
			{ 
				Y_MIN -1; 
				Y_MAX 1; 
			}

			SHADERLINK HAIRMATERIAL_BEND_SHADER { }
		}
	}

	GROUP HAIRMATERIAL_GROUP_CURL
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_CURL { UNIT DEGREE; }
			REAL HAIRMATERIAL_CURL_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		REAL HAIRMATERIAL_CURL_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		GROUP 
		{
			COLUMNS 2;

			LONG HAIRMATERIAL_CURL_DIRECTION
			{
				CYCLE
				{
					HAIRMATERIAL_CURL_DIRECTION_WORLD;
					HAIRMATERIAL_CURL_DIRECTION_LOCAL;
					HAIRMATERIAL_CURL_DIRECTION_RANDOM;
					HAIRMATERIAL_CURL_DIRECTION_HAIR;
				}
			}

			REAL HAIRMATERIAL_CURL_DN_VAR { UNIT PERCENT; MIN -100.0; MAX 100.0; }


			LONG HAIRMATERIAL_CURL_DIRECTION_AXIS
			{
				CYCLE
				{
					HAIRMATERIAL_CURL_DIRECTION_AXIS_X;
					HAIRMATERIAL_CURL_DIRECTION_AXIS_Y;
					HAIRMATERIAL_CURL_DIRECTION_AXIS_Z;
					HAIRMATERIAL_CURL_DIRECTION_AXIS_SHADER;
				}
			}

			STATICTEXT { NEWLINE; }
		}

		SHADERLINK HAIRMATERIAL_CURL_DN_SHADER { }

		GROUP HAIRMATERIAL_GROUP_CURL_ADVANCED
		{
			SPLINE HAIRMATERIAL_CURL_CURVE
			{ 
			}

			SHADERLINK HAIRMATERIAL_CURL_SHADER { }
		}
	}

	GROUP HAIRMATERIAL_GROUP_TWIST
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			LONG HAIRMATERIAL_TWIST_AROUND
			{
				CYCLE
				{
					HAIRMATERIAL_TWIST_AROUND_NORMAL;
					HAIRMATERIAL_TWIST_AROUND_ROOT;
					HAIRMATERIAL_TWIST_AROUND_GUIDE;
				}
			}

			BOOL HAIRMATERIAL_TWIST_KEEP_LENGTH { }
		}

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_TWIST { UNIT DEGREE; }
			REAL HAIRMATERIAL_TWIST_VAR { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		REAL HAIRMATERIAL_TWIST_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SPLINE HAIRMATERIAL_TWIST_CURVE
		{ 
		}

		SHADERLINK HAIRMATERIAL_TWIST_SHADER { }
	}

	GROUP HAIRMATERIAL_GROUP_WAVE
	{
		HIDDEN;

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_WAVE { UNIT PERCENT; }
			REAL HAIRMATERIAL_WAVE_VAR { UNIT PERCENT; MIN 0.0; }

			REAL HAIRMATERIAL_WAVE_X { UNIT PERCENT; MIN 0.0; }
			REAL HAIRMATERIAL_WAVE_Y { UNIT PERCENT; MIN 0.0; }
		}

		REAL HAIRMATERIAL_WAVE_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		GROUP HAIRMATERIAL_GROUP_WAVE_ADVANCED
		{
			GROUP
			{
				COLUMNS 2;

				REAL HAIRMATERIAL_WAVE_PHASE_X { UNIT DEGREE; MIN 0.0; MAX 360.0; }
				REAL HAIRMATERIAL_WAVE_PHASE_Y { UNIT DEGREE; MIN 0.0; MAX 360.0; }

				REAL HAIRMATERIAL_WAVE_FREQ_X { MIN 0.0; }
				REAL HAIRMATERIAL_WAVE_FREQ_Y { MIN 0.0; }
			}

			SPLINE HAIRMATERIAL_WAVE_CURVE_X
			{ 
			}

			SPLINE HAIRMATERIAL_WAVE_CURVE_Y
			{ 
			}

			SHADERLINK HAIRMATERIAL_WAVE_SHADER { }
		}
	}

	GROUP HAIRMATERIAL_GROUP_STRAIGHTEN
	{
		HIDDEN;

		LONG HAIRMATERIAL_STRAIGHTEN_TOWARDS
		{
			CYCLE
			{
				HAIRMATERIAL_STRAIGHTEN_TOWARDS_ROOT;
				HAIRMATERIAL_STRAIGHTEN_TOWARDS_NORMAL;
				HAIRMATERIAL_STRAIGHTEN_TOWARDS_GUIDE;
			}
		}

		REAL HAIRMATERIAL_STRAIGHTEN_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		GROUP
		{
			COLUMNS 2;

			REAL HAIRMATERIAL_STRAIGHTEN_STRENGTH	{ UNIT PERCENT; MIN -100.0; MAX 100.0; }
			REAL HAIRMATERIAL_STRAIGHTEN_STRENGTH_VAR	{ UNIT PERCENT; }
		}

		SPLINE HAIRMATERIAL_STRAIGHTEN_CURVE
		{
		}

		SHADERLINK HAIRMATERIAL_STRAIGHTEN_SHADER { }
	}

	GROUP HAIRMATERIAL_ID_MATERIALGROUP_ILLUMINATION
	{
		GROUP
		{
			COLUMNS 2;

			BOOL HAIRMATERIAL_MATERIAL_GLOBALILLUM_RECEIVE	{}
			REAL HAIRMATERIAL_MATERIAL_GLOBALILLUM_RECEIVE_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 10000.0; }
		}

		SEPARATOR { LINE; }

		REAL HAIRMATERIAL_LIGHTING_DIFFUSE_STRENGTH	{ UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }

		REAL HAIRMATERIAL_LIGHTING_ROUGHNESS	{ UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL HAIRMATERIAL_LIGHTING_ROUGHNESS_VAR	{ UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }
						
		REAL HAIRMATERIAL_LIGHTING_REFLECT	{ UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL HAIRMATERIAL_LIGHTING_TRANSMIT	{ UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }

		REAL HAIRMATERIAL_LIGHTING_SHADOWDENSITY	{ UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL HAIRMATERIAL_LIGHTING_SHADOW			{ UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL HAIRMATERIAL_LIGHTING_SELF_SHADOW		{ UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL HAIRMATERIAL_LIGHTING_BACK_SHADOW		{ UNIT PERCENT; MIN 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP HAIRMATERIAL_GROUP_ASSIGN
	{
		SCALE_V;

		MATASSIGN HAIRMATERIAL_ASSIGN { TAG_ID 1017729; MATERIAL_ID 1017730; CONTAINER_ID 1000; SCALE_V; }
	}
}
